use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 0  

declare @ClientPayload01 nvarchar(max) = N'
-- 66369
IF NOT EXISTS(SELECT 1 FROM [SAT].[QuestionSettingDefinitions] WHERE Id = 219)
BEGIN
	SET IDENTITY_INSERT [SAT].[QuestionSettingDefinitions] ON
    	INSERT [SAT].[QuestionSettingDefinitions] ([Id], [Name], [SettingType], [Translatable], [Exclusive]) VALUES (219, N''UseMobileRenderingForDesktop'', 2, 0, 1)
	SET IDENTITY_INSERT [SAT].[QuestionSettingDefinitions] OFF

	DELETE FROM [SAT].[QuestionTypeSettingDefinitions] WHERE QuestionSettingDefinitionId = 219
	INSERT [SAT].[QuestionTypeSettingDefinitions]([DefaultValue], [QuestionSettingDefinitionId], [QuestionTypeId]) VALUES (''false'', 219, 14); -- HybridGrid question type
	INSERT [SAT].[QuestionTypeSettingDefinitions]([DefaultValue], [QuestionSettingDefinitionId], [QuestionTypeId]) VALUES (''false'', 219, 16); -- ChoiceGrid question type
	INSERT [SAT].[QuestionTypeSettingDefinitions]([DefaultValue], [QuestionSettingDefinitionId], [QuestionTypeId]) VALUES (''false'', 219, 17); -- ImageChoiceGrid question type
END
'

declare @ClientPayload02 nvarchar(max) = N'
--66386
IF EXISTS(SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_GetRespondentResponses]'') AND TYPE in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[A4S_sp_GetRespondentResponses]
'

declare @ClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetRespondentResponses]
 @surveyId INT,
 @respondentId INT,
 @search NVARCHAR(255) = '''',
 @advancedFilter nvarchar(MAX) = '''',
 @sort NVARCHAR(255) = '''',
 @startIndex INT = 1,
 @endIndex INT = 10
AS
BEGIN
 DECLARE @schemaName nvarchar(40)
 SET @schemaName = [dbo].GetProjectSchema(@surveyId)
 DECLARE @stmt nvarchar(max) 
 DECLARE @innerQuery nvarchar(max)
 DECLARE @DefaultViewedUnansweredQuestionCode nvarchar(max) = null

 IF (@sort IS NULL OR LEN(@sort) <= 0 ) SET @sort = ''[Position]''

 IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0 ) SET @advancedFilter = '' AND '' + @advancedFilter

 IF EXISTS (select * from sys.columns where [object_id] = object_id(''[SAT].[SurveyOptions]'') and [name] = ''DefaultViewedUnansweredQuestionCode'')
  BEGIN
 SELECT @DefaultViewedUnansweredQuestionCode = so.[DefaultViewedUnansweredQuestionCode] FROM SAT.SurveyOptions so
 WHERE so.Id = CONVERT(nvarchar, @surveyId) and so.[Version] = 0
  END

 SET @innerQuery = ''(SELECT ROW_NUMBER() OVER (ORDER BY b.Position, bi.Position, v.Id) AS [Position], b.Name AS [Block], q.Name AS [Question], q.[Type_Id] as [QuestionTypeId], ''
 
   IF @DefaultViewedUnansweredQuestionCode IS NOT NULL
   BEGIN
    SET @innerQuery += 
    ''CASE WHEN EXISTS (SELECT * FROM '' + @schemaName + ''.[RespondentTraversedQuestions] rtq 
         WHERE rtq.[ResRespondent] = @respondentId
         AND rtq.QuestionId = q.Id)
    THEN 1
    ELSE 0
    END as IsQuestionTraversed, ''
   END
 
   SET @innerQuery += '' STUFF((SELECT '''', ''''+ t.[Text] FROM [SAT].[LocalizableTexts] AS t 
    INNER JOIN [SAT].[LocalizableTexts_QuestionText] AS qt ON t.[Id]=qt.[Id] 
    WHERE qt.[Version]=0 AND t.[Version]=0 AND t.[Language]=so.[DefaultLanguage] AND qt.[QuestionId]=q.[Id] 
	FOR XML PATH(''''''''), TYPE).value(''''.'''',''''NVARCHAR(MAX)''''),1,2,'''' '''') 
	AS [QuestionText], 
    v.Name AS [Variable], v.DataType AS [VariableDataType], ISNULL(r1.RpsMatrix, 1) As [Row],
    STUFF((SELECT '''', '''' + RpsContent
       FROM '' + @schemaName + ''.Response r2
       WHERE r2.RpsQuestion = v.Name
       AND r2.RpsMatrix = ISNULL(r1.RpsMatrix, 1)
       AND r2.RpsRespondent = r1.RpsRespondent
       ORDER BY RpsMention
       FOR XML PATH(''''''''), TYPE).value(''''.'''', ''''nvarchar(max)''''), 1, 1, '''''''')        
    AS [Content],
    STUFF((SELECT '''', '''' + SUBSTRING(RpsOpened, 0, 255)
       FROM '' + @schemaName + ''.Response r2
       WHERE r2.RpsQuestion = v.Name
       AND r2.RpsMatrix = ISNULL(r1.RpsMatrix, 1)
       AND r2.RpsRespondent = r1.RpsRespondent
       AND DATALENGTH(RpsOpened) > 0
       ORDER BY RpsMention
       FOR XML PATH(''''''''), TYPE).value(''''.'''', ''''nvarchar(max)''''), 1, 1, '''''''')
     AS [OpenEnd]
   FROM SAT.Variables v
   LEFT JOIN '' + @schemaName + ''.Response r1 ON r1.RpsQuestion = v.Name AND RpsRespondent = @respondentId
   INNER JOIN SAT.BlockItems_Question q ON v.QuestionId = q.Id AND q.Version = 0
   INNER JOIN SAT.BlockItems bi ON q.Id = bi.Id AND bi.Version = 0
   INNER JOIN SAT.Blocks b ON bi.BlockId = b.Id AND b.Version = 0
   INNER JOIN SAT.SurveyOptions so ON b.QuestionnaireId = so.Id and so.Version = 0
   WHERE b.QuestionnaireId = @surveyId AND v.Version = 0 AND q.Type_Id != 36
    GROUP BY r1.RpsRespondent, b.Position, b.Name, bi.Position, so.DefaultLanguage, q.Id, q.Name, v.Id, v.Name, v.DataType, q.[Type_Id], ISNULL(r1.RpsMatrix, 1)) AS subquery''
    
 SET @stmt = ''SELECT [Position], [Block], [Question], [QuestionText], [Variable], [VariableDataType], [Row], ''
  
 IF @DefaultViewedUnansweredQuestionCode IS NULL
 BEGIN
  SET @stmt += ''[Content], ''
 END
 ELSE
 BEGIN
  SET @stmt += ''COALESCE(NULLIF(LTRIM(RTRIM([Content])), ''''''''), (SELECT CASE WHEN IsQuestionTraversed = 1 AND QuestionTypeId NOT IN (32) THEN '''''' + @DefaultViewedUnansweredQuestionCode + '''''' ELSE NULL END)) as Content, ''
 END

  SET @stmt += 
  ''[OpenEnd] FROM
  (SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], * 
  FROM '' + @innerQuery + '' WHERE ([Block] LIKE ''''%'' + @search + ''%'''' OR [Question] LIKE ''''%'' + @search + ''%'''' OR [Variable] LIKE ''''%'' + @search + ''%'''' OR [Content] LIKE ''''%'' + @search + ''%'''')'' + @advancedFilter + '') rowquery
  WHERE [RowNum] >= '' + CONVERT(nvarchar, @startIndex) + '' AND [RowNum] <= '' + CONVERT(nvarchar, @endIndex) + ''
  ORDER BY [RowNum]''

 EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
 SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery
 EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
 
 IF (@search IS NOT NULL AND LEN(@search) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
 BEGIN
  SET @stmt = ''SELECT COUNT(*) AS [TotalDisplayedRecords] FROM '' + @innerQuery + '' WHERE ([Block] LIKE ''''%'' + @search + ''%'''' OR [Question] LIKE ''''%'' + @search + ''%'''' 
     OR [Variable] LIKE ''''%'' + @search + ''%'''' OR [Content] LIKE ''''%'' + @search + ''%'''')'' + @advancedFilter
  EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
 END 
END
'

declare @SurveyPayload01 nvarchar(max) = N'
--66151
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[RespondentTraversedQuestions]'') AND TYPE in (N''U''))
BEGIN
    CREATE TABLE #SURVEY SCHEMA#.[RespondentTraversedQuestions](
        [ResRespondent] [int] NOT NULL,
		[QuestionId] [int] NOT NULL,
		[Matrix] [int] NOT NULL,
		CONSTRAINT PK_RespondentTraversedQuestions PRIMARY KEY CLUSTERED (ResRespondent, QuestionId, Matrix),
		CONSTRAINT FK_RespondentTraversedQuestions_Respondent FOREIGN KEY (ResRespondent)
		    REFERENCES #SURVEY SCHEMA#.[Respondent](ResRespondent)
            ON DELETE CASCADE
	)
END
'

declare @SurveyPayload02 nvarchar(max) = N'
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_UpdateRespondentTraversedQuestions]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
	DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentTraversedQuestions]
'

declare @SurveyPayload03 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentTraversedQuestions]
	@ResRespondent INT,
	@QuestionIds NVARCHAR(MAX),
    @Matrix INT
AS
    DECLARE @stmt nvarchar(MAX) = ''
        INSERT INTO #SURVEY SCHEMA#.[RespondentTraversedQuestions] 
        SELECT
            @ResRespondent,
            ids,
            @Matrix
        FROM 
        (
            values '' + @QuestionIds + ''
        ) as t(ids) 
        WHERE 
            ids NOT IN (
                SELECT 
                    QuestionId 
                FROM 
                    #SURVEY SCHEMA#.RespondentTraversedQuestions 
                WHERE 
                    ResRespondent = @ResRespondent
                AND
                    Matrix = @Matrix
            )
    ''

    EXEC sp_executesql @stmt, N''@ResRespondent INT, @Matrix INT'', @ResRespondent, @Matrix
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait

		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end

	select @TotalSurveys = count(*) from #Survey
	set @SurveyCursor = cursor forward_only for select DBName, SchemaName from #Survey for update of Processed
	open @SurveyCursor
	fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	while @@FETCH_STATUS = 0 begin
		select @SurveyCounter += 1
		select @StatusMessage = 'Updating survey "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @SurveyCounter / @TotalSurveys
		raiserror (@StatusMessage, 0, 1, @ThisSurvey, @SurveyCounter, @TotalSurveys, @StatusPercent) with nowait

		declare @SurveyExists bit = 0;
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'

		select @SQL = N'SELECT @SurveyExistsOutput = 1; if exists (select * from ' + @ThisClient + '.sys.schemas where [name] = ''' + @ThisSurvey + ''') SELECT @SurveyExistsOutput = 1 '
		exec sp_executesql @SQL, N'@SurveyExistsOutput bit out', @SurveyExists out
		--select @SurveyExists

		if @SurveyExists = 1
		BEGIN 
		   print 'Payload 1'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Payload 2'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Payload 3'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL
		   print 'All Payload done!'

        END
        ELSE 
		BEGIN
		   print '  >>>>> Survey has been deleted!'
		END

		update #Survey set Processed = 1 where current of @SurveyCursor
		fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	end

	truncate table #SurveyVerif
	fetch first from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #SurveyVerif select ''' + @ThisClient + ''', SchemaName from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName from #SurveysDone'
		exec @DBSQL @SQL
		fetch next from @ClientCursor into @ThisClient
	end

	close @ClientCursor
	close @SurveyCursor
	deallocate @ClientCursor
	deallocate @SurveyCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

	IF exists (select DBName, SchemaName from #SurveyVerif except select DBName, SchemaName from #Survey where Processed = 1) 
	BEGIN
		raiserror ('  >>>>> New survey(s) have been added or were skipped, going again!', 0, 1)
		insert into #SurveysDone select DBName, SchemaName from #Survey where Processed = 1
		truncate table #DB
		truncate table #Survey
	END 
	ELSE 
    BEGIN
	  SELECT @AllDone = 1
    END

end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone